﻿/*
VERSION:		1.6

USAGE:
	#include "walkInertia.as"
	walk_obj = makeWalk( player_mc );
	
NOTES:
	This system has hooks for these collision and sprite systems:
		MakeSprite()			(Sprite system 1 - RpgMaker)
		WalkCollision
	
ADDING COLLISION:
	A collision system can be added like this:
		walk_obj.collision = new Collision( player_mc, walk_obj, collision_array, -8, -8 );
	The walk_obj is this walk system.
*/
makeWalk = function( player_mc, playerImage_mc )
{
	// create container
	var _this = new Object();
	
	// walkSpeed
	_this.walkSpeed = 0.3;		// top speed
	_this.acel = 0.01;				// acelleration increment
	_this.decel = 0.96;				// brake multiplier
	
	_this.xVel = 0;
	_this.yVel = 0;
	
	//default walk buttons.  This allows the keys to be changed externally.
	_this.up_key = Key.UP;
	_this.down_key = Key.DOWN;
	_this.left_key = Key.LEFT;
	_this.right_key = Key.RIGHT;
	
	
	
	// Make a looping function
	_this.loop = function()
	{
		// detect horz keys
		if( Key.isDown(_this.right_key) )
		{
			playerImage_mc.setDirection("right");
			if(_this.xVel < _this.walkSpeed)
			{
				_this.xVel += _this.acel;
			}
		}
		else if( Key.isDown(_this.left_key) )
		{
			playerImage_mc.setDirection("left");
			if(_this.xVel > -_this.walkSpeed)
			{
				_this.xVel -= _this.acel;
			}
		}
		else
		{
			// decellerate
			if(Math.abs(_this.xVel) > 0.1)
			{
				_this.xVel *= _this.decel;
			}else{
				_this.xVel = 0;
			}
		}
		
		// detect vert keys
		if( Key.isDown(_this.down_key) )
		{
			playerImage_mc.setDirection("down");
			if(_this.yVel < _this.walkSpeed)
			{
				_this.yVel += _this.acel;
			}
		}
		else if( Key.isDown(_this.up_key) )
		{
			playerImage_mc.setDirection("up");
			if(_this.yVel > -_this.walkSpeed)
			{
				_this.yVel -= _this.acel;
			}
		}
		else
		{
			// decellerate
			if(Math.abs(_this.yVel) > 0.1)
			{
				_this.yVel *= _this.decel;
			}else{
				_this.yVel = 0;
			}
		}
		
		// Apply externally-defined collision
		_this.collision.run();
		
		// start or stop the walk animation
		if (_this.xVel || _this.yVel)
		{
			// is moving
			playerImage_mc.setAnim( true );
		}else{
			// is not moving
			playerImage_mc.setAnim( false );
		}
		
		// Move the player
		player_mc._x += _this.xVel;
		player_mc._y += _this.yVel;
		
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 0.03 );
	
	
	
	// return this system
	return _this;
}// makeWalk()